/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.dialogos;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloDialogo;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoBase;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.rendimiento.valores.ModeloValoresConcRetencion;
import ec.gob.sri.dimm.ats.modelo.obj.rendimientos.DetalleAirRendimiento;
import ec.gob.sri.dimm.ats.ui.dialogos.compras.DialogoDetalleAirCompra;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;

public class DialogoConceptoRetencion
extends DialogoBase
implements VistaModelo<DetalleAirRendimiento>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private boolean editando;
    private ListenerValidacionModeloDialogo listenerValidacionModelo;
    private DetalleAirRendimiento modeloDatos;
    private ModeloValoresConcRetencion modeloValores;
    private Text txtTotalDeposito;
    private ComboViewer cvTipoRendimiento;
    private Text txtMonto;
    private Text txtPorcentaje;
    private Text txtValorRetenido;
    private String conceptoActual = "";
    private List<String> conceptosExistentes = new ArrayList<String>();
    private final Periodo periodo;
    private final String esMicroEmpresa;

    public DialogoConceptoRetencion(IWorkbenchPartSite site, boolean editando, List<String> conceptosExistentes, Periodo periodo, String esMicroEmpresa) {
        super(site);
        this.editando = editando;
        this.conceptosExistentes = conceptosExistentes;
        this.periodo = periodo;
        this.esMicroEmpresa = esMicroEmpresa;
    }

    public void setModeloDatos(DetalleAirRendimiento modeloDatos) {
        this.modeloDatos = modeloDatos;
        if (this.editando) {
            this.conceptoActual = modeloDatos.getConceptoRetencion();
        }
    }

    public void inicializarModeloValores() {
        Iva raizModelo = (Iva)this.modeloDatos.getRaizModelo();
        this.modeloValores = new ModeloValoresConcRetencion(raizModelo.getFechaPeriodoDeclarado().get(2) + 1, raizModelo.getFechaPeriodoDeclarado().get(1), this.periodo, this.esMicroEmpresa, raizModelo.getFechaRegistroContableSeleccionada());
        this.modeloValores.inicializar();
    }

    protected Point getInitialSize() {
        return new Point(640, 380);
    }

    public boolean close() {
        this.modeloDatos.removePropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage("Especifique la informaci\u00f3n del concepto de retenci\u00f3n");
        this.setTitle("Concepto de Retenci\u00f3n");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblTipoIdentificacinBeneficiario = new Label(container, 0);
        GridData gd_lblTipoIdentificacinBeneficiario = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTipoIdentificacinBeneficiario.widthHint = 180;
        lblTipoIdentificacinBeneficiario.setLayoutData((Object)gd_lblTipoIdentificacinBeneficiario);
        lblTipoIdentificacinBeneficiario.setText("Tipo de Rendimiento Financiero");
        this.cvTipoRendimiento = new ComboViewer(container, 8);
        this.cvTipoRendimiento.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ElementoNombreValor tipoRendimiento = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (tipoRendimiento != null) {
                    DialogoConceptoRetencion.this.modeloDatos.setConceptoRetencion(((String[])tipoRendimiento.getValor())[0]);
                    DialogoConceptoRetencion.this.modeloDatos.setDescripcionConcepto(tipoRendimiento.getNombre());
                    if (!DialogoConceptoRetencion.this.modeloDatos.getConceptoRetencion().equals(DialogoConceptoRetencion.this.conceptoActual)) {
                        DialogoConceptoRetencion.this.modeloDatos.setPorcentajeRetencion(((String[])tipoRendimiento.getValor())[1] == null ? "0.00" : ((String[])tipoRendimiento.getValor())[1]);
                    }
                    DialogoConceptoRetencion.this.txtPorcentaje.setEditable(((String[])tipoRendimiento.getValor())[1] == null);
                    DialogoConceptoRetencion.this.procesarSustentosEspeciales_323();
                }
            }
        });
        Combo combo_2 = this.cvTipoRendimiento.getCombo();
        GridData gd_combo_2 = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_combo_2.widthHint = 250;
        combo_2.setLayoutData((Object)gd_combo_2);
        Label lblNIdentificacin = new Label(container, 0);
        lblNIdentificacin.setText("Total Dep\u00f3sito");
        this.txtTotalDeposito = new Text(container, 2048);
        this.txtTotalDeposito.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoConceptoRetencion.this.txtTotalDeposito.selectAll();
            }
        });
        this.txtTotalDeposito.setTextLimit(15);
        GridData gd_txtTotalDeposito = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtTotalDeposito.widthHint = 100;
        this.txtTotalDeposito.setLayoutData((Object)gd_txtTotalDeposito);
        Label lblMontoDelRendimiento = new Label(container, 0);
        lblMontoDelRendimiento.setText("Monto(Base imponible Renta)");
        this.txtMonto = new Text(container, 2048);
        this.txtMonto.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoConceptoRetencion.this.txtMonto.selectAll();
            }
        });
        this.txtMonto.setTextLimit(15);
        GridData gd_txtMonto = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtMonto.widthHint = 100;
        this.txtMonto.setLayoutData((Object)gd_txtMonto);
        Label lblPorcentajeDeRetencin = new Label(container, 0);
        lblPorcentajeDeRetencin.setText("Porcentaje de Retenci\u00f3n");
        this.txtPorcentaje = new Text(container, 2048);
        this.txtPorcentaje.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoConceptoRetencion.this.txtPorcentaje.selectAll();
            }
        });
        this.txtPorcentaje.setTextLimit(15);
        this.txtPorcentaje.setEditable(false);
        GridData gd_txtPorcentaje = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtPorcentaje.widthHint = 100;
        this.txtPorcentaje.setLayoutData((Object)gd_txtPorcentaje);
        Label lblValorRetenido = new Label(container, 0);
        lblValorRetenido.setText("Valor Retenido");
        this.txtValorRetenido = new Text(container, 2048);
        this.txtValorRetenido.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoConceptoRetencion.this.txtValorRetenido.selectAll();
            }
        });
        this.txtValorRetenido.setTextLimit(15);
        GridData gd_txtValorRetenido = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtValorRetenido.widthHint = 100;
        this.txtValorRetenido.setLayoutData((Object)gd_txtValorRetenido);
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
        return area;
    }

    private void procesarSustentosEspeciales_323() {
        if (this.modeloDatos.getConceptoRetencion().equals(DialogoDetalleAirCompra.Sustentos.SUS_323E2.getCodigo())) {
            this.modeloDatos.setPorcentajeRetencion(DialogoDetalleAirCompra.Sustentos.SUS_323E2.getPorcentaje());
            this.txtPorcentaje.setEditable(DialogoDetalleAirCompra.Sustentos.SUS_323E2.isEditable());
        }
    }

    public void procesarModeloDatos() {
        String codigoTipoRendimiento = this.modeloDatos.getConceptoRetencion();
        ElementoNombreValor tipoRetencion = this.modeloValores.obtenerTipoIdentificacion(codigoTipoRendimiento);
        if (tipoRetencion != null) {
            AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoRendimiento, (Object)tipoRetencion);
            this.procesarSustentosEspeciales_323();
        }
        this.listenerValidacionModelo = new ListenerValidacionModeloDialogo((InformacionValidable)this.modeloDatos, this){

            public void ejecutarValidacionFinal(ResultadoValidacion resultado) {
                String codigoConcepto = DialogoConceptoRetencion.this.modeloDatos.getConceptoRetencion();
                if (!DialogoConceptoRetencion.this.conceptoActual.equals(codigoConcepto) && DialogoConceptoRetencion.this.conceptosExistentes.contains(codigoConcepto)) {
                    resultado.fallarValidacion("El Concepto de Retenci\u00f3n ya se encuentra registrado para el Comprobante seleccionado");
                }
            }
        };
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoRendimiento.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvTipoRendimiento.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tiposRendimientoModeloValoresObserveList = PojoProperties.list((String)"tiposRendimiento").observe((Object)this.modeloValores);
        this.cvTipoRendimiento.setInput((Object)tiposRendimientoModeloValoresObserveList);
        ISWTObservableValue observeTextTxtTotalDepositoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtTotalDeposito);
        IObservableValue totalDepositoModeloDatosObserveValue = BeanProperties.value((String)"totalDeposito").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtTotalDepositoObserveWidget, totalDepositoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtMontoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtMonto);
        IObservableValue baseImponibleRentaModeloDatosObserveValue = BeanProperties.value((String)"baseImponibleRenta").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtMontoObserveWidget, baseImponibleRentaModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtPorcentajeObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtPorcentaje);
        IObservableValue porcentajeRetencionModeloDatosObserveValue = BeanProperties.value((String)"porcentajeRetencion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtPorcentajeObserveWidget, porcentajeRetencionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtValorRetenidoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtValorRetenido);
        IObservableValue valorRetenidoModeloDatosObserveValue = BeanProperties.value((String)"valorRetenido").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtValorRetenidoObserveWidget, valorRetenidoModeloDatosObserveValue, null, null);
        return bindingContext;
    }
}

